function [scatter] = scatter_output(Hs,Te,Dir,Hs_bin,Te_bin,Ntot)
%% normal power and energy matrices
d      = mean(diff(Te_bin));
Xedges = linspace(Te_bin(1)-d/2, Te_bin(end)+d/2, length(Te_bin)+1);

d      = mean(diff(Hs_bin));
Yedges = linspace(Hs_bin(1)-d/2, Hs_bin(end)+d/2, length(Hs_bin)+1);

[occ,~,~] = histcounts2(Te,Hs,Xedges,Yedges);

occurrences = occ'/Ntot;

power_m = 0.49*(Hs_bin'.^2).*Te_bin;   % [kW/m]
energy  = power_m.*occurrences*24*365; % [kWh/m/year]

%% directionality plot
sectors = linspace(0,355,72);
dtheta  = (sectors(2)-sectors(1))/2;

tot = 0;
for ii = 1:length(sectors)
    kk = 1;
    for jj = 1:length(Dir)
        if ii == 1
            if (Dir(jj)>(sectors(end)+dtheta))||(Dir(jj)<(sectors(ii)+dtheta))
                sec(ii).Hs(kk) = Hs(jj);
                sec(ii).Te(kk) = Te(jj);
                kk = kk+1;
            end
        else
            if (Dir(jj)>(sectors(ii)-dtheta))&&(Dir(jj)<(sectors(ii)+dtheta))
                sec(ii).Hs(kk) = Hs(jj);
                sec(ii).Te(kk) = Te(jj);
                kk = kk+1;
            end
        end
    end
end
total.occ = [];
total.en  = [];
for ii = 1:length(sec)
    [occ,~,~] = histcounts2(sec(ii).Te,sec(ii).Hs,Xedges,Yedges);
    occ   = occ/Ntot;
    energ = power_m.*occ';
    occ   = sum(occ)';
    energ = sum(energ')';
    
    sec(ii).occ    = occ;
    sec(ii).energy = energ;
    total.occ      = [total.occ,sec(ii).occ];
    total.en       = [total.en,sec(ii).energy];
end

scatter.Hs_bin  = Hs_bin;
scatter.Te_bin  = Te_bin;
scatter.sectors = sectors;
scatter.dir_occ = total.occ;
scatter.dir_en  = total.en;
scatter.energy  = energy;
scatter.occ     = occurrences;
end

